% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{fbhc.sevt}
\alias{fbhc.sevt}
\title{Fast backward hill-climbing}
\usage{
fbhc.sevt(object = NULL, score = function(x) return(-BIC(x)),
  max_iter = Inf, trace = 0)
}
\arguments{
\item{object}{a staged event tree model}

\item{score}{the score function to be maximized}

\item{max_iter}{the maximum number of iteration}

\item{trace}{if >0 increasingly amount of info
is printed (via \code{message})}
}
\value{
The final staged event tree obtained.
}
\description{
Fast backward hill-climbing search of staged event trees with
iterative joining of stages.
}
\details{
For each variable the algorithm try to join stages
and move to the first model that increase the score. When no
increase is possible it moves to the next variable.
}
\examples{
DD <- generate_xor_dataset(n = 5, N = 100)
model <- fbhc.sevt(full(DD), trace = 2)
summary(model)
}
