% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{naive.sevt}
\alias{naive.sevt}
\title{Naive staged event tree}
\usage{
naive.sevt(object, distance = kl, k = length(object$tree))
}
\arguments{
\item{object}{a full staged event tree}

\item{distance}{a distance between probabilities}

\item{k}{the maximum number of variable to consider}
}
\value{
A staged event tree with two stages per variable
}
\description{
Build a stage event tree with two stages for each variable
}
\examples{
DD <- generate_xor_dataset(n = 4, N = 1000)[,5:1]
naive_model <- naive.sevt(full(DD, lambda = 1))
pr <- predict(naive_model, newdata = DD[501:1000,])
table(pr,DD$C[501:1000])
}
