% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-util-functions.R
\name{probdist}
\alias{probdist}
\alias{lp}
\alias{ry}
\alias{kl}
\alias{tv}
\alias{hl}
\alias{bh}
\alias{cd}
\title{Distances between probabilities}
\usage{
lp(x, y, p = 2, ...)

ry(x, y, alpha = 2, ...)

kl(x, y, ...)

tv(x, y, ...)

hl(x, y, ...)

bh(x, y, ...)

cd(x, y, ...)
}
\arguments{
\item{x}{vector of probabilities}

\item{y}{vector of probabilities}

\item{p}{exponent in the \eqn{L^p} norm}

\item{...}{additional parameters for compatibility}

\item{alpha}{the order of the Renyi divergence}
}
\value{
The distance between \code{p} and \code{q}
}
\description{
Distances between probabilities
}
\details{
Functions to compute distances between probabilities:
\itemize{
\item \code{lp}: the \eqn{L^p} distance, \eqn{||x - y||_p^p}
\item \code{ry}: the symmetric Renyi divergence of order \eqn{\alpha}
\item \code{kl}: the symmetrized Kullback-Leibler divergence
\item \code{tv}: the total variation or \eqn{L^1} norm
\item \code{hl}: the (squared) Hellinger distance
\item \code{bh}: the Bhattacharyya distance
\item \code{cd}: the Chan-Darwiche distance
}
}
