% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-search-order.R
\name{search_greedy}
\alias{search_greedy}
\title{Greedy Order Search}
\usage{
search_greedy(
  data,
  alg = stages_bhc,
  search_criterion = BIC,
  lambda = 0,
  join_unobserved = TRUE,
  ...
)
}
\arguments{
\item{data}{either a data.frame or a table containing the data.}

\item{alg}{a function that performs stages structure estimation. Similar to
\code{\link{stages_bhc}} or \code{\link{stages_hclust}}.
The function \code{alg} must accept the argument
\code{scope}.}

\item{search_criterion}{the criterion minimized in the order search.}

\item{lambda}{numerical value passed to \code{\link{full}}.}

\item{join_unobserved}{logical, passed to \code{\link{full}}.}

\item{...}{additional arguments, passed to \code{alg}.}
}
\value{
The estimated staged event tree model.
}
\description{
Search the optimal staged event tree
with a greedy heuristic.
}
\details{
The greedy approach implemented in this function
iteratively adds variables to the staged tree that
better improve the \code{search_criterion}.
}
\examples{
model <- search_greedy(Titanic, alg = stages_fbhc)
print(model)
}
