% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanModel.R
\name{PMXStanModel}
\alias{PMXStanModel}
\title{Creation of a \code{PMXStanModel} object}
\usage{
PMXStanModel(type = "PK", path = "model_temp", route = "1st_order_abs",
  solver = NULL, ode = NULL, pk.struct = "2-cmpt", pk.param = "CL_V",
  obs.state = NULL, theta = NULL, eta = NULL, fixed = NULL,
  compile = FALSE)
}
\arguments{
\item{type}{a string to specify the type of model: "PK" (default) or "PKPD".}

\item{path}{a string to specify the path that will be used to store the model, Stan input data, and model fitting 
and diagnostic results.}

\item{route}{a string to specify mode of drug administration: "1st_order_abs" (default), "IV_bolus", or "IV_infusion".}

\item{solver}{a string to specify which solver to be used for a PK model: "closed_form" (default) or "ODE";
ignored for PKPD models in ODE form.}

\item{ode}{a string to specify equations of the ODE system for a PKPD model; ignored for PK models.}

\item{pk.struct}{a string to specify the PK model structure: "1-cmpt", "2-cmpt" (default), or "3-cmpt"; 
ignored for PKPD models in ODE form.}

\item{pk.param}{a string to specify the method for PK model parameterization: "CL_V" (default), or "micro_rate";
ignored for PKPD models in ODE form.}

\item{obs.state}{an integer to specify the index of the state variable corresponding to observed data for a PKPD model in ODE form;
ignored for PK model with closed-form solution, but required for PKPD models.}

\item{theta}{a string or vector of strings to specify which parameters will be estimated for a PKPD model in ODE form; 
ignored for PK model with closed-form solution, but cannot be \code{NULL} for PKPD models.}

\item{eta}{a string or vector of strings to specify which parameters will have inter-individual variability for a PKPD model 
in ODE form; ignored for PK model with closed-form solution, and can be \code{NULL} for PKPD models.}

\item{fixed}{a vector of strings to specify which parameter values will be fixed at constants for a PKPD model in ODE 
form; ignored for PK model with closed-form solution, and can be \code{NULL} for PKPD models.}

\item{compile}{a logical variable indicating whether to compile the generated Stan code during the initialization 
process (\code{TRUE}) or not (\code{FALSE}, as default). Note that a \code{PMXStanModel} object can be 
compiled at any time after initialization by calling the \code{compile} method (see \emph{Value} 
and \emph{Details} sections).}
}
\value{
A \code{PMXStanModel} object, with the following list of methods:
\item{get.model.specs}{returns model specification.}
\item{generate.stancode}{generates Stan code according to model specification.}
\item{get.state.var}{returns names of state variables in the ODE system. }
\item{get.ode.par}{returns names of parameters in the ODE system.}
\item{get.ntheta}{returns number of parameters to be estimated for an ODE-based PKPD model.}
\item{get.neta}{returns number of inter-individual variabilities set by user for an ODE-based PKPD model.}
\item{get.stan.file}{returns path of the auto-generated Stan file.}
\item{compile.stanmodel}{compiles the Stan file, either auto-generated (default) or with a path specified by user.   
                         This function has a generic form \code{\link{compile}}. 
                        }
\item{get.compile.status}{returns a logical indicator whether the model-associated Stan file has been compiled or not.}
\item{retrieve.stanmodel}{returns the compiled Stan model.}
\item{print.model}{returns the compiling status and the path of the model-associated Stan file, as well as model specifications.
                   This function has a generic form \code{\link{print}}.   
                  }
}
\description{
Initializes an object of class \code{PMXStanModel} with methods for generating and compiling Stan code and 
querying model specifications.
}
\details{
\code{PMXStanModel} serves as an interface for practical PK/PD modeling using Stan under a Bayesian framework. 
The first step of building such a model is for a user to provide model specifications (for more details on 
specification arguments and default values, please refer to the \emph{Arguments} section). With a proper set of 
specifications, a model-specific Stan source code is then generated based on a generic template code for the 
associated model type. Users then can choose to compile the auto-generated Stan source code directly 
to a self-contained platform-specific executable, or to modify the Stan source code according to their own modeling 
strategies before compiling it to an executable. 

The template Stan code serves at least two purposes. First, it presents a grammar-corrected ready-to-be-used code 
that already takes care of most technical details necessary to build such a model in Stan; secondly, it makes sure 
that everything needed for running Stan sampling is internally consistent, from preparing the compatible data list, 
interpreting various dosing events and schedule, to calling the appropriate solver. In a template Stan code, model 
parameters to be estimated are defined as \code{theta}'s and inter-individual variabilities for parameters are defined 
as \code{eta}'s, to follow the conventions in pharmacometrics practice. All priors are set as non-informative. 
It needs to be kept in mind that the code is fully accessible and modifiable by a user; therefore, a user can add 
his/her own customized code by changing certain part of the auto-generated code conveniently. The modified Stan code  
can be re-compiled at any time as long as the changes made by users comply with standard Stan grammar. It is suggested  
that in these cases, a user begins with making small changes and testing the compilation (as well as compatibility with 
the input data if necessary) gradually before going to more significant modifications.
}
\examples{
\dontrun{
### A population PK model
m1 <- PMXStanModel(path = tempfile("pk_m1"), compile = TRUE)
print(m1)

### A population PKPD model
ode <- "
  C2 = centr/V;
  d/dt(depot) =-ka*depot;
  d/dt(centr) = ka*depot - ke*centr;
  d/dt(eff) = (1+Emax*C2/(C2+EC50))*Kin - Kout*eff;
"
instant.stan.extension(ode)

m5 <- PMXStanModel(type = "PKPD", 
                   path = tempfile("pkpd_m1"),
                   ode = ode, 
                   theta= c("Emax","EC50"),
                   eta = c("Emax","EC50"),
                   fixed = c(V=1, ka=0.5, ke=0.4, Kin=0.5, Kout=0.5),
                   obs.state = 3
                  )
compile(m5)
}
}
\author{
Yuan Xiong and Wenping Wang
}
\references{
The Stan Development Team. \emph{Stan Modeling Language User's Guide and Reference Manual}. \url{https://mc-stan.org}.
}
\seealso{
\code{\link{prepareInputData}} for transformation of a NONMEM-readable dataset to a list compatiable to auto-generated 
model-specific Stan code;
\code{\link{PMXStanFit}} for how to run the compiled Stan executable for the model, link it with the input data and 
generate posterior samples of parameters, and perform model diagnostics;
\code{rstan-stanmodel} for a class specifically referred to the compiled model.
}

