% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{obs.vs.pred}
\alias{obs.vs.pred}
\title{Pointwise comparison between observed data vs. predicted medians.}
\usage{
obs.vs.pred(fit, ...)
}
\arguments{
\item{fit}{a \code{PMXStanFit} object.}

\item{...}{additional arguments.}

}
\description{
Plots medians of predictions vs. observations for goodness-of-fit assessment, either for the
whole population or for subgroups classified by a given covariate. This function is a generic 
version of the method \code{plot.gof.pred.obs()} for the \code{\link{PMXStanFit}} class.
}
\value{No return value, called for side effects}
\examples{
\donttest{
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m1)

fit <- PMXStanFit(m1, dat, iter=100, chains=1)

obs.vs.pred(fit)
}
}
\seealso{
\code{\link{PMXStanFit}} for the methods \code{plot.gof.pred.obs()}.
}

