#' @export
st_as_stars.STFDF = function(.x, ...) {
    if (!requireNamespace("sp", quietly = TRUE))
        stop("package sp required, please install it first") #nocov
    if (!requireNamespace("zoo", quietly = TRUE))
        stop("package zoo required, please install it first") #nocov
	#ix = 1:prod(dim(.x)[c("space", "time")])
	d = if (sp::gridded(.x@sp)) {
			gp = sp::gridparameters(.x@sp)
			nx = gp[1,3]
			ny = gp[2,3]
			if (! sp::fullgrid(.x@sp)) { # SpatialPixels
				lst = vector("list", ncol(.x@data))
				for (j in seq_along(.x@data)) {
					px2vec = function(pix) {
						sp::fullgrid(pix) = TRUE
						as.vector(as.matrix(pix))
					}
					a = array(NA_real_, c(nx, ny, dim(.x)[2]))
					for (i in seq_len(dim(.x)[2]))
						a[,,i] = px2vec(.x[,i])
					lst[[j]] = as.vector(a)
				}
				.x@data = as.data.frame(setNames(lst, names(.x@data)))
			}
			# offs_x dx 0 offs_y 0 dy
			gt = c(gp[1,1] - gp[1,2]/2, gp[1,2], 0.0, gp[2,1] + (gp[2,3] - 0.5) * gp[2,2], 0.0, -gp[2,2])
			vals = lapply(seq_len(nrow(gp)), function(i) seq(gp[i,1], by = gp[i,2], length.out = gp[i,3]))
			create_dimensions(list(
				x = create_dimension(values = vals[[1]] - gp[1,2]/2),
				y = create_dimension(values = rev(vals[[2]]) + gp[2,2]/2),
				time = create_dimension(values = zoo::index(.x@time))),
				raster = get_raster())
		} else
			create_dimensions(list(
				sfc = create_dimension(values = st_as_sfc(.x@sp)), # FIXME: doesn't do SpatialPixels -> x/y
				time = create_dimension(values = zoo::index(.x@time))))
	vals = lapply(.x@data, function(y) { dim(y) = dim(d); y })
	st_set_crs(st_as_stars(vals, dimensions = d), sp::proj4string(.x@sp))
}

st_as_STFDF = function(x) {

    if (!requireNamespace("sp", quietly = TRUE))
        stop("package sp required, please install it first") #nocov
    if (!requireNamespace("spacetime", quietly = TRUE))
        stop("package spacetime required, please install it first") #nocov
	rst = has_raster(x)
	d = st_dimensions(x)
	e = expand_dimensions(d)
	geom = if (rst) {
			xy = attr(d, "raster")$dimensions
			tm = e[[ setdiff(names(d), xy) ]]
			x = st_upfront(x, xy)
			sp::geometry(as(adrop(x[,,,1]), "Spatial"))
		} else {
			w = which_sfc(x)
			tm = e[[ setdiff(seq_along(dim(x)), w) ]]
			x = st_upfront(x, w)
			sp::geometry(as(adrop(x[,,1]), "Spatial"))
		}

	st = suppressWarnings(spacetime::STF(geom, tm)) # would warn for SpatialGrid -> SpatialPixels

	sp::addAttrToGeom(st, as.data.frame(lapply(x, function(y) structure(y, dim = NULL))), match.ID = FALSE)
}

setAs("stars", "STFDF", function(from) { 
    if (!requireNamespace("sp", quietly = TRUE))
        stop("package sp required, please install it first") #nocov
    if (!requireNamespace("zoo", quietly = TRUE))
        stop("package zoo required, please install it first") #nocov
    if (!requireNamespace("xts", quietly = TRUE))
        stop("package xts required, please install it first") #nocov
    if (!requireNamespace("spacetime", quietly = TRUE))
        stop("package spacetime required, please install it first") #nocov
	st_as_STFDF(from)
})
