% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starschemar.R
\docType{package}
\name{starschemar}
\alias{starschemar}
\title{Obtaining Star Schemas from Flat Tables}
\description{
Transformations that allow obtaining star schemas from flat tables.
}
\details{
From flat tables star schemas can be defined that can form constellations
(\emph{star schema and constellation definition functions}). Dimensions contain
data without duplicates, operations to do data cleaning can be applied on
them (\emph{data cleaning functions}). When new data is obtained, it is necessary
to refresh the existing data with them by means of incremental refresh
operations (\emph{incremental refresh functions}). Finally, the results obtained
can be exported to be consulted with other tools (\emph{results export
functions}).
}
\section{Star schema and constellation definition}{
 Starting from a flat
table, a dimensional model is defined specifying the attributes that make
up each of the dimensions and the measurements in the facts. The result is
a \code{dimensional_model} object. It is carried out through the following
\emph{dimensional model definition functions}:
\itemize{
\item \code{\link[=dimensional_model]{dimensional_model()}}
\item \code{\link[=define_dimension]{define_dimension()}}
\item \code{\link[=define_fact]{define_fact()}}
}

A star schema is defined from a flat table and a dimensional model
definition. Once defined, a star schema can be transformed by defining role
playing dimensions, changing the writing style of element names or the type
of dimension attributes. These operations are carried out through the
following \emph{star schema definition and transformation functions}:
\itemize{
\item \code{\link[=star_schema]{star_schema()}}
\item \code{\link[=role_playing_dimension]{role_playing_dimension()}}
\item \code{\link[=snake_case]{snake_case()}}
\item \code{\link[=character_dimensions]{character_dimensions()}}
}

Based on various star schemas, a constellation can be defined in which star
schemas share common dimensions. Dimensions with the same name must be
shared. It is defined by the following \emph{constellation definition function}:
\itemize{
\item \code{\link[=constellation]{constellation()}}
}
}

\section{Data cleaning}{
 Once the star schemas and constellations are defined,
data cleaning operations can be carried out on dimensions. There are three
groups of functions: one to obtain dimensions of star schemas and
constellations; another to define data cleaning operations over dimensions;
and one more to apply operations to star schemas or constellations.

\emph{Obtaining dimensions}:
\itemize{
\item \code{\link[=get_dimension_names]{get_dimension_names()}}
\item \code{\link[=get_dimension]{get_dimension()}}
\item \code{\link[=get_conformed_dimension_names]{get_conformed_dimension_names()}}
\item \code{\link[=get_conformed_dimension]{get_conformed_dimension()}}
}

\emph{Update definition functions}:
\itemize{
\item \code{\link[=record_update_set]{record_update_set()}}
\item \code{\link[=match_records]{match_records()}}
\item \code{\link[=update_record]{update_record()}}
\item \code{\link[=update_selection]{update_selection()}}
\item \code{\link[=update_selection_general]{update_selection_general()}}
}

\emph{Modification application functions}:
\itemize{
\item \code{\link[=modify_dimension_records]{modify_dimension_records()}}
\item \code{\link[=modify_conformed_dimension_records]{modify_conformed_dimension_records()}}
}
}

\section{Incremental refresh}{
 When new data is obtained, an incremental
refresh of the data can be carried out, both of the dimensions and of the
facts. Incremental refresh can be applied to both star schema and
constellation, using the following functions:
\itemize{
\item \code{\link[=incremental_refresh_star_schema]{incremental_refresh_star_schema()}}
\item \code{\link[=incremental_refresh_constellation]{incremental_refresh_constellation()}}
}
}

\section{Results export}{
 Once the data has been properly structured and
transformed, it can be exported to be consulted with other tools. Various
export formats have been defined, both for star schemas and for
constellations, using the following functions:
\itemize{
\item \code{\link[=star_schema_as_flat_table]{star_schema_as_flat_table()}}
\item \code{\link[=star_schema_as_multistar]{star_schema_as_multistar()}}
\item \code{\link[=star_schema_as_tibble_list]{star_schema_as_tibble_list()}}
\item \code{\link[=constellation_as_multistar]{constellation_as_multistar()}}
\item \code{\link[=constellation_as_tibble_list]{constellation_as_tibble_list()}}
}
}

