% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.test.R
\name{matching.test}
\alias{matching.test}
\title{Matching test}
\usage{
matching.test(
  x,
  size,
  null.prob = 0,
  alternative = "greater",
  approx = (length(x) > 100)
)
}
\arguments{
\item{x}{Sample vector containing values from the generalised matching distribution}

\item{size}{The size parameter (number of objects to match)}

\item{null.prob}{The null value of the probability parameter}

\item{alternative}{The alternative hypothesis}

\item{approx}{A logical value specifying whether to use the normal approximation to the distribution}
}
\value{
An htest object giving the output of the matching test
}
\description{
\code{matching.test} performs the matching test.
}
\details{
The matching test considers a situation where a person attempts to match a set of objects to a corresponding set of
positions.  The null hypothesis is that the matching is performed at random and the alternative hypothesis is that the
matching occurs with some ability on the part of the player.

For data vectors \code{x} that are not too large we perform an exact test by computing the exact distribution of the 
mean number of matches.  If the number of data points is too large then we perform an approximate test using the normal
approximation to the distribution of the mean number of matches.  The parameter \code{max.m} sets the maximum number of 
data points where we perform an exact test.
}
