% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reformat}
\alias{reformat}
\alias{as.data.frame.hdr}
\alias{as.data.frame.ci}
\title{Reformat HDRs and confidence intervals objects}
\usage{
reformat(OBJ)

\method{as.data.frame}{hdr}(x, ...)

\method{as.data.frame}{ci}(x, ...)
}
\arguments{
\item{OBJ}{An object to reformat (either a HDR or a confidence interval)}

\item{x}{an R object}

\item{...}{unused}
}
\value{
Returns the reformatted object
}
\description{
This function reformats HDRs and confidence intervals back and forth between set format and data frame format.  If the object is a 'hdr'
object (HDR presented as a set) it is reformatted into a 'hdr.df' object (HDR presented as a data frame) and *vice versa*.  If the object
is a 'ci' object (confidence interval as a set) it is reformatted into a 'ci.df' object (confidence interval presented as a data frame)
and *vice versa*.  All attributes and information is preserved when changing formats.  If the object is not of a recognised kind (or is
of multiple recognised kinds) then it is returned unchanged and the function gives a warning.
}
