% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anogva.R
\name{anogva}
\alias{anogva}
\title{ANOGVA Analysis Of Graph Variability}
\usage{
anogva(Graphs, labels, maxBoot = 1000, dist = "KL", ...)
}
\arguments{
\item{Graphs}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{labels}{an array of integers indicating the labels of each graph.}

\item{maxBoot}{integer indicating the number of bootstrap resamplings (default \code{1000}).}

\item{dist}{string indicating if you want to use the "KL" (default), "JS" , "L1" or "L2"
distances. "KL" means Kullback-Leibler divergence. "JS" means Jensen-Shannon divergence.}

\item{...}{Other relevant parameters for \code{\link{graph.spectral.density}}.}
}
\value{
A list with class "htest" containing the following components:
\item{\code{statistic:}}{ the statistic of the test.}
\item{\code{p.value:}}{ the p-value of the test.}
\item{\code{method:}}{ a string indicating the used method.}
\item{\code{data.name:}}{a string with the data's name(s).}
}
\description{
\code{anogva} statistically tests whether two or more sets of graphs are generated
by the same random graph model. It is a generalization of the \code{takahashi.test}
function.
}
\examples{

set.seed(1)
g1 <- g2 <- g3 <- list()
for (i in 1:20) {
  g1[[i]] <- igraph::sample_gnp(50, 0.50)
  g2[[i]] <- igraph::sample_gnp(50, 0.50)
  g3[[i]] <- igraph::sample_gnp(50, 0.52)
}
G <- c(g1, g2, g3)
label <- c(rep(1,20),rep(2,20),rep(3,20))
result <- anogva(G, label, maxBoot=50)
result

}
\references{
Fujita, A., Vidal, M. C. and Takahashi, D. Y. (2017) A Statistical Method to
Distinguish Functional Brain Networks. _Front. Neurosci._, *11*, 66.
doi:10.3389/fnins.2017.00066.

Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{analysis_of_graph_variability}
