% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{shp_all_us_congressional_districts}
\alias{shp_all_us_congressional_districts}
\title{Shapefiles detailing the Congressional Districts of the USA, designed for subsetting to the contiguous USA.}
\format{Simple feature collection with 444 features and 12 fields
\describe{
  \item{state.fips}{State FIP code}
  \item{district.name}{Congressional District name}
  \item{state.short.name}{Two-character short name for state}
  \item{state.name}{State name}
  \item{state.ns}{GNIS ID for State}
  \item{aff.geo.id}{American Fact Finder Geo ID}
  \item{geoid}{Unknown identifier from Census}
  \item{congressional.session}{Congressional session (all identical)}
  \item{contiguous.united.states}{Is a member of the contiguous US? TRUE/FALSE}
  \item{is.state}{Is this Congressional District part of a recognised State? TRUE/ FALSE}
  \item{state.region}{Region the parent state belongs to}
  \item{state.divison}{Division the parent state belongs to}
  \item{geometry}{MULTIPOLYGON, defines the border of the Congressional District}
}}
\source{
\url{http://www2.census.gov/geo/tiger/GENZ2016/shp/cb_2016_us_cd115_20m.zip}
}
\usage{
shp_all_us_congressional_districts
}
\description{
An "sf" "data.frame" representing congressional districts of the United States of America with 20m = 1:20,000,000 resolution, from www.census.gov.
}
\examples{
## Filter out only congressional districts from the contiguous US
library("dplyr")
shp_contiguous_us_congressional_districts <- shp_all_us_congressional_districts \%>\%
 filter(contiguous.united.states)
}
\keyword{datasets}
