/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import ints.IntArray;
import ints.IntList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class PbwtDivUpdater {
    private final int nHaps;
    private IntList[] a;
    private IntList[] d;
    private int[] p;

    public PbwtDivUpdater(int n2) {
        int n3 = 4;
        this.nHaps = n2;
        this.p = new int[n3];
        this.a = (IntList[])IntStream.range(0, n3).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        this.d = (IntList[])IntStream.range(0, n3).mapToObj(n -> new IntList()).toArray(IntList[]::new);
    }

    public int nHaps() {
        return this.nHaps;
    }

    public void fwdUpdate(IntArray intArray, int n, int n2, int[] nArray, int[] nArray2) {
        if (intArray.size() != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(intArray.size()));
        }
        if (nArray.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        this.initializeArrays(n, n2 + 1);
        for (int i = 0; i < this.nHaps; ++i) {
            int n3 = intArray.get(nArray[i]);
            if (n3 >= n) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            for (int j = 0; j < n; ++j) {
                if (nArray2[i] <= this.p[j]) continue;
                this.p[j] = nArray2[i];
            }
            this.a[n3].add(nArray[i]);
            this.d[n3].add(this.p[n3]);
            this.p[n3] = Integer.MIN_VALUE;
        }
        this.updatePrefixAndDiv(n, nArray, nArray2);
    }

    public void bwdUpdate(IntArray intArray, int n, int n2, int[] nArray, int[] nArray2) {
        if (intArray.size() != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(intArray.size()));
        }
        if (nArray.length != this.nHaps) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        this.initializeArrays(n, n2 - 1);
        for (int i = 0; i < this.nHaps; ++i) {
            int n3 = intArray.get(nArray[i]);
            if (n3 >= n) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            for (int j = 0; j < n; ++j) {
                if (nArray2[i] >= this.p[j]) continue;
                this.p[j] = nArray2[i];
            }
            this.a[n3].add(nArray[i]);
            this.d[n3].add(this.p[n3]);
            this.p[n3] = Integer.MAX_VALUE;
        }
        this.updatePrefixAndDiv(n, nArray, nArray2);
    }

    private void updatePrefixAndDiv(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.a[i].size();
            System.arraycopy(this.a[i].toArray(), 0, nArray, n2, n3);
            System.arraycopy(this.d[i].toArray(), 0, nArray2, n2, n3);
            n2 += n3;
            this.a[i].clear();
            this.d[i].clear();
        }
        assert (n2 == this.nHaps);
    }

    private void initializeArrays(int n, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.ensureArrayCapacity(n);
        Arrays.fill(this.p, 0, n, n2);
    }

    private void ensureArrayCapacity(int n) {
        if (n > this.a.length) {
            int n2 = this.a.length;
            this.p = Arrays.copyOf(this.p, n);
            this.a = Arrays.copyOf(this.a, n);
            this.d = Arrays.copyOf(this.d, n);
            for (int i = n2; i < this.a.length; ++i) {
                this.a[i] = new IntList();
                this.d[i] = new IntList();
            }
        }
    }
}

