/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.FileIt;
import blbutil.Filter;
import blbutil.SampleFileIt;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import vcf.BasicGTRec;
import vcf.BitSetGTRec;
import vcf.GTRec;
import vcf.LowMafDiallelicGTRec;
import vcf.LowMafGTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfHeader;
import vcf.VcfRec;
import vcf.VcfRecGTParser;

public class VcfIt<E extends GTRec>
implements SampleFileIt<E> {
    private static final float DEFAULT_MAX_LR = Float.MAX_VALUE;
    private final VcfHeader vcfHeader;
    private final FileIt<String> it;
    private final Function<String, E> mapper;
    private String next;
    private final Filter<Marker> markerFilter;
    private final int bufferSize;
    private final String[] stringBuffer;
    private final Deque<E> recBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final BiFunction<VcfHeader, String, GTRec> TO_LOWMEM_GT_REC = (vcfHeader, string) -> {
        VcfRecGTParser.HapListRep hapListRep = new VcfRecGTParser((VcfHeader)vcfHeader, (String)string).hapListRep();
        int n = hapListRep.samples().size() >> 7;
        if (hapListRep.nonmajorAlleleCnt() <= n) {
            if (hapListRep.marker().nAlleles() == 2) {
                return new LowMafDiallelicGTRec(hapListRep);
            }
            return new LowMafGTRec(hapListRep);
        }
        return new BitSetGTRec(hapListRep);
    };
    public static final BiFunction<VcfHeader, String, GTRec> TO_BASIC_GT_REC = (vcfHeader, string) -> new BasicGTRec(new VcfRecGTParser((VcfHeader)vcfHeader, (String)string));
    public static final BiFunction<VcfHeader, String, VcfRec> TO_VCF_REC = (vcfHeader, string) -> VcfRec.fromGTGL(vcfHeader, string, Float.MAX_VALUE);

    static String[] head(String string, FileIt<String> fileIt) {
        String string2;
        String string3 = "#";
        ArrayList<String> arrayList = new ArrayList<String>(32);
        String string4 = string2 = fileIt.hasNext() ? (String)fileIt.next() : null;
        while (string2 != null && string2.startsWith(string3)) {
            arrayList.add(string2);
            string2 = fileIt.hasNext() ? (String)fileIt.next() : null;
        }
        if (string2 == null) {
            throw new IllegalArgumentException("ERROR: missing VCF data lines (" + string + ")");
        }
        arrayList.add(string2);
        return arrayList.toArray(new String[0]);
    }

    public static <R extends GTRec> VcfIt<R> create(FileIt<String> fileIt, BiFunction<VcfHeader, String, R> biFunction) {
        return VcfIt.create(fileIt, Filter.acceptAllFilter(), Filter.acceptAllFilter(), biFunction);
    }

    public static <R extends GTRec> VcfIt<R> create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, R> biFunction) {
        return VcfIt.create(fileIt, filter, filter2, biFunction, 1024);
    }

    public static <R extends GTRec> VcfIt<R> create(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, R> biFunction, int n) {
        return new VcfIt<R>(fileIt, filter, filter2, biFunction, n);
    }

    private VcfIt(FileIt<String> fileIt, Filter<String> filter, Filter<Marker> filter2, BiFunction<VcfHeader, String, E> biFunction, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (filter2 == null) {
            filter2 = Filter.acceptAllFilter();
        }
        String string2 = fileIt.file() == null ? "stdin" : fileIt.file().getName();
        String[] stringArray = VcfIt.head(string2, fileIt);
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length - 1);
        String string3 = stringArray[stringArray.length - 1];
        boolean[] blArray = VcfHeader.isDiploid(string3);
        this.it = fileIt;
        this.vcfHeader = new VcfHeader(string2, stringArray2, blArray, filter);
        this.mapper = string -> (GTRec)biFunction.apply(this.vcfHeader, (String)string);
        this.next = string3;
        this.markerFilter = filter2;
        this.bufferSize = n;
        this.stringBuffer = new String[VcfIt.stringBufferSize(this.next, n)];
        this.recBuffer = new ArrayDeque(n);
        this.fillEmissionBuffer();
    }

    private static int stringBufferSize(String string, int n) {
        long l = Runtime.getRuntime().maxMemory();
        long l2 = 2 * (string == null ? 0 : string.length());
        long l3 = 1L + (l >> 4) / l2;
        return (int)Math.min(l3, (long)n);
    }

    private void fillEmissionBuffer() {
        assert (this.recBuffer.isEmpty());
        int n2 = -1;
        while (n2 != 0 && this.recBuffer.size() < this.bufferSize) {
            n2 = this.fillStringBuffer(this.stringBuffer.length);
            if (n2 <= 0) continue;
            List list = IntStream.range(0, n2).parallel().mapToObj(n -> this.stringBuffer[n]).map(this.mapper).filter(gTRec -> this.markerFilter.accept(gTRec.marker())).collect(Collectors.toList());
            this.recBuffer.addAll(list);
        }
    }

    private int fillStringBuffer(int n) {
        int n2 = 0;
        if (this.next != null) {
            while (this.next != null && n2 < n) {
                this.stringBuffer[n2++] = this.next;
                this.next = VcfIt.readLine(this.it);
            }
        }
        return n2;
    }

    private static String readLine(FileIt<String> fileIt) {
        if (!fileIt.hasNext()) {
            return null;
        }
        String string = (String)fileIt.next();
        while (string.trim().isEmpty() && fileIt.hasNext()) {
            string = (String)fileIt.next();
        }
        return string;
    }

    @Override
    public void close() {
        this.next = null;
        this.it.close();
        this.recBuffer.clear();
        Arrays.fill(this.stringBuffer, null);
    }

    @Override
    public boolean hasNext() {
        return !this.recBuffer.isEmpty();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        GTRec gTRec = (GTRec)this.recBuffer.removeFirst();
        if (this.recBuffer.isEmpty()) {
            this.fillEmissionBuffer();
        }
        return (E)gTRec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" : ");
        stringBuilder.append(this.it.file() == null ? "stdin" : this.it.file().toString());
        return stringBuilder.toString();
    }
}

