% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covUnstr.R
\name{covUnstr}
\alias{covUnstr}
\alias{covPW}
\title{Compute unstructured covariance}
\usage{
covUnstr(Y, K, X = NULL, fixDiag = FALSE, VeDiag = FALSE)

covPW(Y, K, X = NULL, fixDiag = FALSE, corMat = FALSE, parallel = FALSE)
}
\arguments{
\item{Y}{An n x p matrix of observed phenotypes, on p traits or trials
for n individuals. No missing values are allowed.}

\item{K}{An n x n kinship matrix.}

\item{X}{An n x c covariate matrix, c being the number of covariates and n
being the number of genotypes.}

\item{fixDiag}{Should the diagonal of the covariate matrix be fixed during
calculations? -- NOT YET IMPLEMENTED}

\item{VeDiag}{Should Ve be a diagonal matrix?}

\item{corMat}{Should the output be a correlation matrix instead of a
covariance matrix?}

\item{parallel}{Should the computation of variance components be done in
parallel?}
}
\value{
A list of two matrices \code{Vg} and \code{Ve} containing genotypic
and environmental variance components respectively.
}
\description{
Compute unstructured covariance pairwise using \code{covPairwise} or using a
single model using \code{covUnstr}.
}
\keyword{internal}
