% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTD.R
\name{TD}
\alias{TD}
\alias{createTD}
\alias{addTD}
\alias{dropTD}
\title{S3 class TD}
\usage{
createTD(
  data,
  genotype = NULL,
  trial = NULL,
  loc = NULL,
  year = NULL,
  repId = NULL,
  subBlock = NULL,
  plotId = NULL,
  rowCoord = NULL,
  colCoord = NULL,
  rowId = rowCoord,
  colId = colCoord,
  checkId = NULL,
  trLocation = NULL,
  trDate = NULL,
  trDesign = NULL,
  trLat = NULL,
  trLong = NULL,
  trPlWidth = NULL,
  trPlLength = NULL
)

addTD(
  TD,
  data,
  genotype = NULL,
  trial = NULL,
  loc = NULL,
  year = NULL,
  repId = NULL,
  subBlock = NULL,
  plotId = NULL,
  rowCoord = NULL,
  colCoord = NULL,
  rowId = rowCoord,
  colId = colCoord,
  checkId = NULL,
  trLocation = NULL,
  trDate = NULL,
  trDesign = NULL,
  trLat = NULL,
  trLong = NULL,
  trPlWidth = NULL,
  trPlLength = NULL
)

dropTD(TD, rmTrials)
}
\arguments{
\item{data}{A data.frame containing trial data with at least a column for
genotype. The data.frame should be in a wide format, i.e. all available
phenotypic data should be in a separate column within the data.frame.}

\item{genotype}{An optional character string indicating the column in
\code{data} that contains genotypes.}

\item{trial}{An optional character string indicating the column in
\code{data} that contains trials.}

\item{loc}{An optional character string indicating the column in
\code{data} that contains trial locations.}

\item{year}{An optional character string indicating the column in \code{data}
that contains years.}

\item{repId}{An optional character string indicating the column in
\code{data} that contains replicates.}

\item{subBlock}{An optional character string indicating the column in
\code{data} that contains sub blocks.}

\item{plotId}{An optional character string indicating the column in
\code{data} that contains plots. This column will be combined with trial
to a single output factor.}

\item{rowCoord}{An optional character string indicating the column in
\code{data} that contains the row coordinates.}

\item{colCoord}{An optional character string indicating the column in
\code{data} that contains the column coordinates.}

\item{rowId}{An optional character string indicating the column in
\code{data} that contains field rows. If not supplied, this is assumed to
be the same as rowCoord.}

\item{colId}{An optional character string indicating the column in
\code{data} that contains field columns. If not supplied, this is assumed to
be the same as colCoord.}

\item{checkId}{An optional character string indicating the column in
\code{data} that contains the check IDs.}

\item{trLocation}{An optional character vector indicating the locations of
the trials. This will be used as default names when creating plots and
summaries. If no locations are provided, first the column loc is considered.
If this contains one unique value for a trial this is used as trLocation.
Otherwise the trialname is used.}

\item{trDate}{An optional date vector indicating the dates of the trials.}

\item{trDesign}{An optional character vector indicating the designs of the
trials. Either "none" (no (known) design), "ibd" (incomplete-block design),
"res.ibd" (resolvable incomplete-block design), "rcbd" (randomized complete
block design), "rowcol" (row-column design) or "res.rowcol" (resolvable
row-column design).}

\item{trLat}{An optional numerical vector indicating the latitudes of the
trials on a scale of -90 to 90.}

\item{trLong}{An optional numerical vector indicating the longitudes of the
trials on a scale of -180 to 180.}

\item{trPlWidth}{An optional positive numerical vector indicating the
widths of the plots.}

\item{trPlLength}{An optional positive numerical vector indicating the
lengths of the plots.}

\item{TD}{An object of class TD which should be modified.}

\item{rmTrials}{A character vector of trials that should be removed.}
}
\value{
An object of class TD, a list of data.frames with renamed columns
and an attribute \code{renamedCols} containing an overview of renamed
columns. For each unique value of trial, the output has a data.frame in
the list with the same name as the trial. These data.frames have attributes
containing the metadata for the corresponding trial. If there is no column
for trial, the list will contain one item named after the input data.
}
\description{
\code{createTD}\cr
Function for creating objects of S3 class TD (Trial Data). The function
converts a data.frame to an object of class TD in the following steps:
\itemize{
\item{Check input data}
\item{Rename columns to default column names - default column names:
genotype, trial, loc, year, repId, subBlock, rowCoord, colCoord, rowId,
colId, checkId}
\item{Convert column types to default column types - rowCoord and colCoord
are converted to numeric columns, all other renamed columns to factor
columns. Columns other than the default columns, e.g. traits or other
covariates will be included in the output unchanged.}
\item{Split input data by trial - each trial in the input data will become
a list item in the output.}
\item{Add meta data - the trial meta data are added as attributes to the
different output items. The function parameters starting with "tr" provide
the meta data. Their values will be recycled if needed, so by setting a
single "trDesign", all trials will get the same design. The meta data can be
changed later on using \code{getMeta} and \code{setMeta}}
}
\code{addTD}\cr
Function for adding extra trial data to an existing object of class TD. The
data for the new trials will be added after the data for existing trials. It
is possible to add data for an already existing trial, but this will cause
multiple items in the output with identical names, which might cause problems
later on in the analysis. Therefore a warning will be issued in this
case.\cr\cr
\code{dropTD}\cr
Function for removing data for selected trials from an existing object of
class TD.\cr\cr
\code{\link{summary.TD}} and \code{\link{plot.TD}} methods are available.
}
\examples{
## Create a data.frame with to be converted to TD object.
## The data consists of genotype, trial, row and column information and
## two traits, yield and flowering time.
datT1 <- data.frame(geno = paste0("G", 1:10), tr = "T1",
                    row = rep(1:5, each = 2), col = rep(1:2, times = 5),
                    yield = 1:10, flowering = 3:12)

## Convert data.frame to TD object.
TDT1 <- createTD(data = datT1, genotype = "geno", trial = "tr",
                 rowCoord = "row", colCoord = "col")

## Create a second data.frame similar to the first with data for a second trial.
datT2<- data.frame(geno = paste0("G", 1:10), tr = "T2",
                    row = rep(1:2, each = 5), col = rep(1:5, times = 2),
                    yield = 10:1, flowering = 12:3)

## Add this data to the TD object created above.
TDTot <- addTD(TD = TDT1, data = datT2, genotype = "geno", trial = "tr",
               rowCoord = "row", colCoord = "col")

## Drop the data for the first trial from the object.
TDT2 <- dropTD(TD = TDTot, rmTrials = "T1")

}
\seealso{
Other functions for TD objects: 
\code{\link{getMeta}()},
\code{\link{plot.TD}()},
\code{\link{summary.TD}()}
}
\concept{functions for TD objects}
