% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-utils.R
\name{mcmc-utilities}
\alias{mcmc-utilities}
\alias{colMeans.mcmc.list}
\alias{sweep.mcmc.list}
\alias{lapply.mcmc.list}
\title{Utility operations for \code{\link{mcmc.list}} objects}
\usage{
colMeans.mcmc.list(x, ...)

sweep.mcmc.list(x, STATS, FUN = "-", check.margin = TRUE, ...)

lapply.mcmc.list(X, FUN, ...)
}
\arguments{
\item{x}{a \code{\link{mcmc.list}} object.}

\item{\dots}{additional arguments to \code{\link{colMeans}} or
\code{\link{sweep}}.}

\item{STATS, FUN, check.margin}{See help for \code{\link{sweep}}.}

\item{X}{An \code{\link{mcmc.list}} object.}
}
\value{
\code{colMeans.mcmc} returns a vector with length equal to
the number of mcmc chains in \code{x} with the mean value for
each chain.

\code{sweep.mcmc.list} returns an appropriately modified
version of \code{x}

\code{lapply.mcmc.list} returns an \code{\link{mcmc.list}} each of
whose chains had been passed through \code{FUN}.
}
\description{
\code{colMeans.mcmc.list} is a "method" for (non-generic) \code{\link{colMeans}} applicable to \code{\link{mcmc.list}} objects.

\code{sweep.mcmc.list} is a "method" for (non-generic)
\code{\link{sweep}} applicable to \code{\link{mcmc.list}} objects.

\code{lapply.mcmc.list} is a "method" for (non-generic)
\code{\link{lapply}} applicable to \code{\link{mcmc.list}} objects.
}
\examples{
data(line, package="coda")
summary(line) # coda
colMeans.mcmc.list(line) # "Method"
\dontshow{
stopifnot(isTRUE(all.equal(summary(line)$statistics[,"Mean"],colMeans.mcmc.list(line))))
}
data(line, package="coda")
colMeans.mcmc.list(line)-1:3
colMeans.mcmc.list(sweep.mcmc.list(line, 1:3))
\dontshow{
stopifnot(isTRUE(all.equal(colMeans.mcmc.list(sweep.mcmc.list(line, 1:3)), colMeans.mcmc.list(line)-1:3)))
}
if(getRversion()<'3.5' && .Platform$OS.type=="windows"){
message("Windows versions of R prior to 3.5.0 appear ",
        "to have a bug that causes this example to fail.")
}else{
data(line, package="coda")
print(colMeans.mcmc.list(line)[c(2,3,1)])
print(colMeans.mcmc.list(lapply.mcmc.list(line, `[`,,c(2,3,1))))
\dontshow{
stopifnot(isTRUE(all.equal(colMeans.mcmc.list(line)[c(2,3,1)],colMeans.mcmc.list(lapply.mcmc.list(line, `[`,,c(2,3,1))))))
}
}
}
\seealso{
\code{\link{colMeans}}, \code{\link{mcmc.list}}

\code{\link{sweep}}

\code{\link{lapply}}
}
