% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.stdmean.ps}
\alias{ci.stdmean.ps}
\title{Confidence interval for a paired-samples standardized mean difference}
\usage{
ci.stdmean.ps(alpha, m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{sample mean of measurement 1}

\item{m2}{sample mean of measurement 2}

\item{sd1}{sample standard deviation in measurement 1}

\item{sd2}{sample standard deviation in measurement 2}

\item{cor}{sample correlation between measurements}

\item{n}{sample size}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item Estimate - bias adjusted standardized mean difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized mean difference
in a paired-samples design. A square root unweighted variance standardizer
and single measurement standard deviation standardizers are used. Equality
of variances is not assumed.
}
\examples{
ci.stdmean.ps(.05, 110.4, 102.1, 15.3, 14.6, .75, 25)

# Should return:
#                              Estimate        SE        LL        UL
# Unweighted standardizer:     0.5433457 0.1609934 0.2394905 0.8705732
# Measurement 1 standardizer:  0.5253526 0.1615500 0.2258515 0.8591158
# Measurement 2 standardizer:  0.5505407 0.1692955 0.2366800 0.9003063


}
\references{
\insertRef{Bonett2008}{statpsych}
}
