% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.mean.ps}
\alias{size.test.mean.ps}
\title{Sample size for a test of a paired-samples mean difference}
\usage{
size.test.mean.ps(alpha, pow, var, es, cor)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average variance of the two measurements}

\item{es}{planning value of mean difference}

\item{cor}{planning value of correlation}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a difference in population means
with desired power in a paired-samples design. Set the correlation planning
value to the smallest value within a plausible range for a conservatively
large sample size. Set the variance planning value to the largest value
within a plausible range for a conservatively large sample size.
}
\examples{
size.test.mean.ps(.05, .80, 1.25, .5, .75) 

# Should return:
#      Sample size
# [1,]          22
 

}
