% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.2x2.prop.bs}
\alias{ci.2x2.prop.bs}
\title{Computes tests and confidence intervals of effects in a 2x2 between-
subjects design for proportions}
\usage{
ci.2x2.prop.bs(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - adjusted estimate of effect
\item SE - standard error
\item z - z test statistic for test of null hypothesis
\item p - p-value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals and tests for the AB
interaction effect, main effect of A, main efect of B, simple main effects
of A, and simple main effects of B in a 2x2 between-subjects factorial
design with a dichotomous response variable. The input vector of
frequency counts is f = [ f11, f12, f21, f22 ], and the input vector of
sample sizes is n = [ n11, n12, n21, n22 ] where the first subscript
represents the levels of Factor A and the second subscript represents the
levels of Factor B.
}
\examples{
f <- c(15, 24, 28, 23)
n <- c(50, 50, 50, 50)
ci.2x2.prop.bs(.05, f, n)

# Should return:
#             Estimate         SE          z           p          LL          UL
# AB:      -0.27450980 0.13692496 -2.0048193 0.044982370 -0.54287780 -0.00614181
# A:       -0.11764706 0.06846248 -1.7184165 0.085720668 -0.25183106  0.01653694
# B:       -0.03921569 0.06846248 -0.5728055 0.566776388 -0.17339968  0.09496831
# A at b1: -0.25000000 0.09402223 -2.6589456 0.007838561 -0.43428019 -0.06571981
# A at b2:  0.01923077 0.09787658  0.1964798 0.844234654 -0.17260380  0.21106534
# B at a1: -0.17307692 0.09432431 -1.8349132 0.066518551 -0.35794917  0.01179533
# B at a2:  0.09615385 0.09758550  0.9853293 0.324462356 -0.09511021  0.28741790


}
\references{
\insertRef{Price2004}{statpsych}
}
