% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.spear2}
\alias{ci.spear2}
\title{Confidence interval for a 2-group Spearman correlation difference}
\usage{
ci.spear2(alpha, cor1, cor2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{estimated Spearman correlation for group 1}

\item{cor2}{estimated Spearman correlation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference in population Spearman
correlations in a 2-group design.
}
\examples{
ci.spear2(.05, .54, .48, 180, 200)

# Should return:
# Estimate         SE         LL        UL
#     0.06 0.08124926 -0.1003977 0.2185085     
 

}
\references{
\insertRef{Bonett2000}{statpsych}

\insertRef{Zou2007}{statpsych}
}
