% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.bayes.prop}
\alias{ci.bayes.prop}
\title{Bayesian credible interval for a proportion}
\usage{
ci.bayes.prop(alpha, prior_mean, prior_sd, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha credibility interval}

\item{prior_mean}{mean of prior Beta distribution}

\item{prior_sd}{standard deviation of prior Beta distribution}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Posterior mean - posterior mean of Beta distribution
\item Posterior SD - posterior standard deviation of Beta distribution
\item LL - lower limit of the credible interval
\item UL - upper limit of the credible interval
}
}
\description{
Computes a Bayesian credible interval for a population proportion using the
mean and standard deviation of a prior Beta distribution along with sample
information. The mean and standard deviation of the posterior Beta
distribution are also reported. For a noninformative prior, set the prior
mean to .5 and the prior standard deviation to 1/sqrt(12) (which
corresponds to a Beta(1,1) distribution). The prior variance must be
less than m(1 - m) where m is the prior mean.
}
\examples{
ci.bayes.prop(.05, .4, .1, 12, 100)

# Should return:
# Posterior mean Posterior SD       LL        UL
#      0.1723577   0.03419454 0.1111747 0.2436185


}
\references{
\insertRef{Gelman2004}{statpsych}
}
