% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_lgl.R, R/stabilize_lgl_scalar.R,
%   R/to_lgl.R, R/to_lgl_scalar.R
\name{stabilize_lgl}
\alias{stabilize_lgl}
\alias{stabilize_lgl_scalar}
\alias{to_lgl}
\alias{to_lgl_scalar}
\title{Ensure a logical argument meets expectations}
\usage{
stabilize_lgl(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  min_size = NULL,
  max_size = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_lgl_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_lgl(
  x,
  allow_null = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_lgl_scalar(
  x,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{These dots are for future extensions and should be empty.}

\item{allow_null}{Logical. Is NULL an acceptable value?}

\item{allow_na}{Logical. Are NA values ok?}

\item{min_size}{Integer. The minimum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{Integer. The maximum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{x_arg}{Character. An argument name for x. The automatic value will work
in most cases, or pass it through from higher-level functions to make error
messages clearer in unexported functions.}

\item{call}{The execution environment of the call. See the \code{call} argument of
\code{rlang::abort()} for more information.}

\item{x_class}{Character. The class name of \code{x} to use in error messages. Use
this if you remove a special class from \code{x} before checking its coercion,
but want the error message to match the original class.}

\item{allow_zero_length}{Logical. Are zero-length vectors acceptable?}
}
\value{
The argument as a logical vector.
}
\description{
\code{to_lgl()} checks whether an argument can be coerced to
logical without losing information, returning it silently if so.
Otherwise an informative error message is signaled.

\code{stabilize_lgl()} can check more details about the argument, but is slower
than \code{to_lgl()}.

\code{stabilize_lgl_scalar()} and \code{to_lgl_scalar()} are optimized to check for
length-1 logical vectors.
}
\examples{
to_lgl(TRUE)
to_lgl("TRUE")
to_lgl(1:10)
to_lgl(NULL)
try(to_lgl(NULL, allow_null = FALSE))
try(to_lgl(letters))
try(to_lgl(list(TRUE)))

to_lgl_scalar("TRUE")
try(to_lgl_scalar(c(TRUE, FALSE)))

stabilize_lgl(c(TRUE, FALSE, TRUE))
stabilize_lgl("true")
stabilize_lgl(NULL)
try(stabilize_lgl(NULL, allow_null = FALSE))
try(stabilize_lgl(c(TRUE, NA), allow_na = FALSE))
try(stabilize_lgl(letters))
try(stabilize_lgl(c(TRUE, FALSE, TRUE), min_size = 5))
try(stabilize_lgl(c(TRUE, FALSE, TRUE), max_size = 2))

stabilize_lgl_scalar(TRUE)
stabilize_lgl_scalar("TRUE")
try(stabilize_lgl_scalar(c(TRUE, FALSE, TRUE)))
stabilize_lgl_scalar(NULL)
try(stabilize_lgl_scalar(NULL, allow_null = FALSE))
}
