% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData_Account.R
\name{getData_Account}
\alias{getData_Account}
\title{Get an overview of account data on the Stellar ledger.}
\usage{
getData_Account(public_key, key, data.table = TRUE)
}
\arguments{
\item{public_key}{character - (required) your Stellar account/wallet address.}

\item{key}{character - (required) a user id}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
data.table (by default) or list
}
\description{
Every account can have an extra data associated with it, such as multiple keys or user-ids. Use this comand to return key value pairs for a specific account. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/data-for-account.html
}
\examples{
\donttest{getData_Account(public_key = "Gsomekey", key = "user-id")}
}
