\name{Data.Sicopolis.par}
\alias{Data.Sicopolis.par}
\docType{data}
\title{
SICOPOLIS model ensemble parameter settings
}
\description{
Parameter settings corresponding to SICOPOLIS ensemble model output in Data.Sicopolis.model.
}
\usage{data(Data.Sicopolis.par)}
\format{
  The format is a list containing three elements
  \describe{
     \item{$par}{ [1:5, 1:100] matrix of parameter settings for the
     SICOPOLIS model ensemble. [row, col] = [parameter number,
     ensemble run number]. The columns match the columns of $out element
     of Data.Sicopolis.model}
     \item{$par}{ Parameter names for rows of $par} 
     \item{$parunits}{Parameter units for rows of $par}
 }
}
\details{
The ensemble was generated by Patrick Applegate. The ensemble varies
five important ice sheet model parameters: Flow Enhancement Factor,
Basal Sliding Factor, Geothermal Heat Flux, Snow PDD Factor, and Ice PDD Factor

}
\source{
  Applegate, P. J., Kirchner, N., Stone, E. J., Keller, K., and Greve, R.,
2012, An assessment of key model parametric uncertainties in projections
of Greenland Ice Sheet behavior: The Cryosphere 6, 589-606.

}
\examples{
# Fit an emulator to the SICOPOLIS ensemble data
data(Data.Sicopolis.par)
data(Data.Sicopolis.model)
\dontrun{emulator(Data.Sicopolis.par, Data.Sicopolis.model, c(FALSE, FALSE,
FALSE, FALSE, FALSE), FALSE, 200000, 20000)}
}
\keyword{datasets}
