\name{emul.Sicopolis}
\alias{emul.Sicopolis}
\docType{data}
\title{
SICOPOLIS ice sheet model emulator
}
\description{
Sample emulator for ice mass loss from the 5-parameter SICOPOLIS ice
sheet model ensemble output 
}
\usage{data(emul.Sicopolis)}
\format{
This is a standard emulator list object, containing standard emulator
  components as described in 'emulator' function. The emulated quantity
  is Greenland ice mass loss relative to year 2003 (Gt).
}
\details{
The emulator was fit using all five parameter covariates, and the time
covariate. The beta parameters are the multiple linear regression
estimates. The model ensemble was generated by Patrick Applegate. The ensemble varies
five important ice sheet model parameters: Flow Enhancement Factor,
Basal Sliding Factor, Geothermal Heat Flux, Snow PDD Factor, and Ice PDD Factor.
}
\source{
Applegate, P. J., Kirchner, N., Stone, E. J., Keller, K., and Greve, R.,
2012, An assessment of key model parametric uncertainties in projections
of Greenland Ice Sheet behavior: The Cryosphere 6, 589-606.
}
\examples{
# Plot the response surface as a function of snow PDD factor, and ice
# PDD factor at year 2500 (time index 661), while keeping other parameters
# at mid-range values
data(emul.Sicopolis)
\dontrun{
  rsurface.plot(emul=emul.Sicopolis, parind=c(4,5), parvals=c(3, 10, 50, NA, NA),
      tind=661, n1=5, n2=5)
}
}
\keyword{datasets}
