% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEA.r
\name{TEA}
\alias{TEA}
\title{Theme enrichment analysis (TEA).}
\usage{
TEA(mystorysets, background_storyset = c("TOS", "TAS", "TNG"),
  theme_levels = c("choice", "major", "minor"), min_storyset_size = 5,
  min_theme_occurrence = 1)
}
\arguments{
\item{mystorysets}{A storysets class object that contains one or many individual storysets.}

\item{background_storyset}{default \code{c("TOS", "TAS", "TNG")}. A string indicating the storyset to use as background.
Possible values are \code{TOS}, \code{TAS}, \code{TNG} and their combinations.}

\item{theme_levels}{\code{c("choice", "major", "minor")}. A string indicating the theme levels to use in the analysis.
Possible values are \code{choice}, \code{major}, \code{minor} and their combinations.}

\item{min_storyset_size}{default \code{5}. The minimum allowable size for a storyset.
For small samples the hypergeometric test may be unreliable.}

\item{min_theme_occurrence}{default \code{1}. The minimum number of times a theme must occur in a storyset.
For small samples the hypergeometric test may be unreliable.}
}
\value{
Returns a data frame where each row corresponds to a theme.
The column Pvalue contains raw enrichment scores, i.e., hypergeometric 
test P-values. The column Padj contains the corresponding Benjamini-Hotchberg
adjusted P-values.
}
\description{
\code{TEA} calculates enrichment scores for themes in
a storset relative to a background set of stories
according to the hypergeometric test.
}
\examples{
#######################################################################
# Load the Star Trek series storysets smt file and storysets object   #
#######################################################################
file <- system.file("storysets", "series.smt", package = "stoRy")
mystorysets <- storysets$new(file)
print(mystorysets)
#######################################################################
# Perform the theme enrichment analysis for each of TOS, TAS, and TNG #
# relative to default TOS/TAS/TNG background                          #
#######################################################################
results <- TEA(mystorysets)
#######################################################################
# Output top ten enriched TOS themes                                  #
#######################################################################
results$TOS[1:10,c("Theme", "NSample", "NOmega", "Pvalue", "Padj")]
#######################################################################
# Output top ten enriched TAS themes                                  #
#######################################################################
results$TOS[1:10,c("Theme", "NSample", "NOmega", "Pvalue", "Padj")]
#######################################################################
# Output top ten enriched TNG themes                                  #
#######################################################################
results$TOS[1:10,c("Theme", "NSample", "NOmega", "Pvalue", "Padj")]
}
