\name{dx}
\alias{dx}
\alias{dy}
\alias{dz}
\docType{data}
\title{Elementary forms in three-dimensional space}
\description{

Objects \code{dx}, \code{dy} and \code{dz} are the three elementary
one-forms on three-dimensional space.  These objects can be generated by
running script \file{vignettes/dx.Rmd}, which includes some further
discussion and technical documentation and creates file \file{dx.rda}
which resides in the \code{data/} directory.

The default print method is a little opaque for these objects.  To print
them more intuitively, use

\preformatted{options(kform_symbolic_print = "dx")}

which is documented at \code{print.Rd}.

}
\usage{data(dx)}
\details{See vignettes \code{dx} and \code{exeyez} for an extended
  discussion; a use-case is given in \code{vector_cross_product}.}
\references{
  \itemize{\item M. Spivak 1971. \emph{Calculus on manifolds},
  Addison-Wesley}
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{d}},\code{\link{print.kform}}}
\examples{

dx
hodge(dx)
hodge(dx,3)


dx  # default print method, not particularly intelligible
options(kform_symbolic_print = 'dx')  # shows dx dy dz
dx
dx^dz
hodge(dx,3)

as.function(dx)(ex)


options(kform_symbolic_print = NULL)  # revert to default


}
\keyword{datasets}
