% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localplot.locstppm.R
\name{localplot.locstppm}
\alias{localplot.locstppm}
\title{Plot the coefficients of a fitted local spatio-temporal Poisson process model}
\usage{
localplot.locstppm(x, par = TRUE)
}
\arguments{
\item{x}{An object of class \code{locstppm}}

\item{par}{Default to \code{TRUE}.}
}
\description{
The function plots the local estimates of a fitted local spatio-temporal Poisson process model.
}
\examples{
\dontrun{
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(0.005, 5), seed = 2)
inh_local <- locstppm(inh, formula = ~ x)

localplot.locstppm(inh_local)

}




}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.
}
\seealso{
\link{locstppm}, \link{print.locstppm}, \link{summary.locstppm},
\link{localsummary.locstppm}, \link{plot.locstppm}
}
\author{
Nicoletta D'Angelo
}
