% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_hierarchy}
\alias{c_hierarchy}
\title{c-hierarchy
captures how well a partition/ultrametric (obtained by hclust) explains the configuration distances. Uses variance explained for euclidean distances and deviance explained for everything else.}
\usage{
c_hierarchy(confs, p = 2, agglmethod = "complete")
}
\arguments{
\item{confs}{a numeric matrix}

\item{p}{the parameter of the Minokwski distances (p=2 euclidean and p=1 is manhattan)}

\item{agglmethod}{the method used for creating the clustering, see \code{\link{hclust}}.}
}
\value{
a numeric value; hierarchy (see \code{\link[clue]{cl_validity}})
}
\description{
c-hierarchy
captures how well a partition/ultrametric (obtained by hclust) explains the configuration distances. Uses variance explained for euclidean distances and deviance explained for everything else.
}
\examples{
delts<-smacof::kinshipdelta
conf<-smacofSym(delts)$conf
c_hierarchy(conf,p=2,agglmethod="single")
}
