% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_winds.R
\name{add_storm_track}
\alias{add_storm_track}
\title{Plot Atlantic basin hurricane tracks}
\usage{
add_storm_track(storm_tracks, plot_object, plot_points = FALSE, alpha = 1,
  color = "firebrick")
}
\arguments{
\item{storm_tracks}{A data frame with best tracks data for the storm
track you would like to add. See the example \code{\link{floyd_tracks}}
data for an example of the required format. This dataset must
include columns for \code{date} (date-time of the track observation),
\code{latitude}, and \code{longitude}.}

\item{plot_object}{NULL or the name of a ggplot object to use as the
underlying plot object (e.g., the output from a call to
\code{\link{map_wind}})}

\item{plot_points}{TRUE / FALSE indicator of whether to include points,
as well as lines, when plotting the hurricane tracks.}

\item{alpha}{Numerical value designating the amount of transparency to
use for plotting tracks.}

\item{color}{Character string giving the color to use to plot the tracks.}
}
\value{
A ggplot object that includes a line with the track of a given
   tropical storm. This object can be printed directly or added
   on to with other ggplot commands.
}
\description{
Plot the tracks of a selected tropical storm to a map of modeled wind
speed.
}
\examples{
\dontrun{
library(ggplot2)
data("county_points")
data("floyd_tracks")
grid_winds_floyd <- get_grid_winds(hurr_track = floyd_tracks,
                                   grid_df = county_points)
floyd_map <- map_wind(grid_winds_floyd, value = "vmax_sust",
                      wind_metric = "knots") +
             ggtitle("Maximum sustained wind speeds")
add_storm_track(floyd_tracks, plot_object = floyd_map)
}

}

