% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_track.R
\name{create_full_track}
\alias{create_full_track}
\title{Impute hurricane tracks to finer time scale}
\usage{
create_full_track(hurr_track = stormwindmodel::floyd_tracks, tint = 0.25)
}
\arguments{
\item{hurr_track}{Dataframe with hurricane track data for a single
storm. The dataframe must include columns for date-time (year, month, day,
hour, minute; e.g., "198808051800" for August 5, 1988, 18:00 UTC),
latitude, longitude, and wind speed (in knots). The column
names for each of these must be \code{date}, \code{latitude},
\code{longitude}, and \code{wind}. See the example \code{\link{floyd_tracks}}
dataset for an example of the required format.}

\item{tint}{Interval (in hours) to which to interpolate the tracks. The
default is 0.25 (i.e., 15 minutes).}
}
\value{
A version of the storm's track data with
   latitude, longitude, and wind speed interpolated between
   observed values. Also, wind speed is converted in this function to m / s
   and the absolute value of the latitude is taken (necessary for further
   wind speed calculations). Finally, the names of some columns are
   changed (\code{tclat} for latitude, \code{tclon} for longitude, and
   \code{vmax} for wind speed.)
}
\description{
Inputs data on a hurricane's track and imputes to a finer time resolution.
For example, if the hurricane tracks are recorded at 6-hour intervals, this
could be used to impute locations and windspeeds at 15-minute intervals.
This function also does some reformatting necessary for later functions in
the \code{stormwindmodel} package.
}
\details{
The function uses natural cubic splines for interpolation for location
and linear splines for interpolation for wind speed. The base R functions
\code{spline} and \code{approx} are used for these interpolations.
}
\note{
This function imputes between each original data point, and it starts
   by determining the difference in time between each pair of data points.
   Because of this, the function can handle data that includes a point
   that is not at one of the four daily synoptic times (00:00, 06:00, 12:00,
   and 18:00). Typically, the only time hurricane observations are given
   outside of synoptic times for best tracks data is at landfall.

After imputing the tracks, longitude is expressed as a positive number.
   This is so the output will work correctly in later functions to fit the
   wind model. However, be aware that you should use the negative value of
   longitude for mapping tracks from the output from this function.
}
\examples{
data("floyd_tracks")
full_track <- create_full_track(hurr_track = floyd_tracks)

# Interpolate to every half hour (instead of default 15 minutes)
full_track <- create_full_track(hurr_track = floyd_tracks, tint = 0.5)

}
