% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{buff_geo}
\alias{buff_geo}
\title{Create a buffer of n metres for non-projected 'geographical' spatial data}
\usage{
buff_geo(shp, width, ..., silent = TRUE)
}
\arguments{
\item{shp}{A spatial object with a geographic CRS (WGS84)
around which a buffer should be drawn}

\item{width}{The distance (in metres) of the buffer}

\item{...}{Arguments passed to rgeos::gBuffer()}

\item{silent}{A binary value for printing the CRS details (default: FALSE)}
}
\description{
Solves the problem that buffers will not be circular when used on
non-projected data.
}
\details{
Returns a
}
\examples{
data("routes_fast")
sp::proj4string(routes_fast) <- CRS("+init=epsg:4326")
buff <- buff_geo(routes_fast, width = 100)
plot(buff)
plot(routes_fast, add = TRUE)
}

