% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{flow}
\alias{flow}
\title{data frame of commuter flows}
\format{A data frame with 49 rows and 15 columns}
\usage{
data(flow)
}
\description{
This dataset represents commuter flows (work travel) between origin
and destination zones (see \code{\link[=cents]{cents()}}).
The data is from the UK and is available as open data:
\url{http://wicid.ukdataservice.ac.uk/}.
}
\details{
The variables are as follows:

\itemize{
\item Area.of.residence. id of origin zone
\item Area.of.workplace id of destination zone
\item All. Travel to work flows by all modes
\item \code{[,4:15]}. Flows for different modes
\item id. unique id of flow
}
Although these variable names are unique to UK data, the data
structure is generalisable and typical of flow data from any source.
The key variables are the origin and destination ids, which link to
the \code{cents} georeferenced spatial objects.
}
\examples{
\dontrun{
# This is how the dataset was constructed - see
# https://github.com/npct/pct - if download to ~/repos
flow <- readRDS("~/repos/pct/pct-data/national/flow.Rds")
data(cents)
o <- flow$Area.of.residence \%in\% cents$geo_code[-1]
d <- flow$Area.of.workplace \%in\% cents$geo_code[-1]
flow <- flow[o & d, ] # subset flows with o and d in study area
library(devtools)
flow$id <- paste(flow$Area.of.residence, flow$Area.of.workplace)
use_data(flow, overwrite = TRUE)

# Convert flows to spatial lines dataset
flowlines <- od2line(flow = flow, zones = cents)
# use_data(flowlines, overwrite = TRUE)

# Convert flows to routes
routes_fast <- line2route(l = flowlines, plan = "fastest")
routes_slow <- line2route(l = flowlines, plan = "quietest")

use_data(routes_fast)
use_data(routes_slow)
routes_fast_sf <- sf::st_as_sf(routes_fast)
routes_slow_sf <- sf::st_as_sf(routes_slow)
}

}
\seealso{
Other example data: \code{\link{destination_zones}},
  \code{\link{flow_dests}}, \code{\link{flowlines}},
  \code{\link{route_network}}, \code{\link{routes_fast}},
  \code{\link{routes_slow}}
}
\concept{example data}
\keyword{datasets}
