% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_bearing}
\alias{line_bearing}
\title{Find the bearing of straight lines}
\usage{
line_bearing(l, bidirectional = FALSE)
}
\arguments{
\item{l}{A spatial lines object}

\item{bidirectional}{Should the result be returned in a bidirectional format?
Default is FALSE. If TRUE, the same line in the oposite direction would have the same bearing}
}
\description{
This is a simple wrapper around the geosphere function \code{\link{bearing}} to return the
bearing (in degrees relative to north) of lines.
}
\details{
Returns a boolean vector. TRUE means that the associated line is in fact a point
(has no distance). This can be useful for removing data that will not be plotted.
}
\examples{
data(flowlines)
b1 <- line_bearing(flowlines)
b2 <- line_bearing(flowlines, bidirectional = TRUE)
plot(b1, b2)
line_bearing(flowlines_sf[1:9, ])
}
