% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{route_cyclestreet}
\alias{route_cyclestreet}
\alias{route_cyclestreets}
\title{Plan a single route with CycleStreets.net}
\usage{
route_cyclestreet(from, to, plan = "fastest", silent = TRUE,
  pat = NULL, base_url = "https://www.cyclestreets.net",
  reporterrors = TRUE, save_raw = "FALSE")
}
\arguments{
\item{from}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth.}

\item{to}{Text string or coordinates (a numeric vector of
\code{length = 2} representing latitude and longitude) representing a point
on Earth. This represents the destination of the trip.}

\item{plan}{Text strong of either "fastest" (default), "quietest" or "balanced"}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used. By default this is set to NULL and
this is usually aquired automatically through a helper, api_pat().}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{reporterrors}{Boolean value (TRUE/FALSE) indicating if cyclestreets (TRUE by default).
should report errors (FALSE by default).}

\item{save_raw}{Boolean value which returns raw list from the json if TRUE (FALSE by default).}
}
\description{
Provides an R interface to the CycleStreets.net cycle planning API,
a route planner made by cyclists for cyclists.
The function returns a SpatialLinesDataFrame object representing the
an estimate of the fastest, quietest or most balance route.
Currently only works for the United Kingdom and part of continental Europe,
though other areas may be requested by contacting CycleStreets.
See \url{https://www.cyclestreets.net/api/}for more information.
}
\details{
This function uses the online routing service
CycleStreets.net to find routes suitable for cyclists
between origins and destinations. Requires an
internet connection, a CycleStreets.net API key
and origins and destinations within the UK (and various areas beyond) to run.

Note that if \code{from} and \code{to} are supplied as
character strings (instead of lon/lat pairs), Google's
geo-coding services are used via \code{geo_code()}.

You need to have an api key for this code to run.
Loading a locally saved copy of the api key text string
before running the function, for example, will ensure it
is available on any computer:

\code{mytoken <- readLines("~/Dropbox/dotfiles/cyclestreets-api-key-rl") Sys.setenv(CYCLESTREET = mytoken)}

if you want the API key to be available in future
sessions, set it using the .Renviron file
e.g. on Linux machines in bash via:

\code{echo "CYCLESTREET=f3fe3d078ac34737" >> ~/.Renviron}

Read more about the .Renviron here: \code{?.Renviron}
}
\examples{

\dontrun{
from <- c(-1.55, 53.80) # geo_code("leeds")
to <- c(-1.76, 53.80) # geo_code("bradford uk")
json_output <- route_cyclestreet(from = from, to = to, plan = "quietest", save_raw = TRUE)
str(json_output) # what does cyclestreets give you?
rf_lb <- route_cyclestreet(from, to, plan = "fastest")
rf_lb@data
plot(rf_lb)
(rf_lb$length / (1000 * 1.61)) / # distance in miles
  (rf_lb$time / (60 * 60)) # time in hours - average speed here: ~8mph
# Plan a 'balanced' route from Pedaller's Arms to the University of Leeds
rb_pa <- route_cyclestreet("Pedaller's Arms, Leeds", "University of Leeds, UK", "balanced")
}

}
\seealso{
line2route
}
