% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{overline2}
\alias{overline2}
\title{Overlay duplicated lines}
\usage{
overline2(x, attrib, ncores = 1, simplify = TRUE,
  regionalise = 10000)
}
\arguments{
\item{x}{SF data frame of linestrings}

\item{attrib}{character, column name to be summed}

\item{ncores}{integer, how many cores to use in parallel processing}

\item{simplify, }{logical, if TRUE group final segments back into lines}

\item{regionalise, }{integer, during simplification regonalisation is used if the number of segments exceeds this value}
}
\description{
Overlay duplicated lines
}
\examples{
sl = routes_fast_sf[routes_fast_sf$length > 0, ]
sl$bicycle = 1
system.time({rnet1 = overline2(sl, "bicycle")})
system.time({rnet2 = overline2(sl, "bicycle", ncores = 4)})
identical(rnet1, rnet2)
lwd = rnet1$bicycle / mean(rnet1$bicycle)
plot(rnet1, lwd = lwd)
\donttest{
region = "isle-of-wight"

u = paste0(
  "https://github.com/npct/pct-outputs-regional-notR/raw/master/commute/msoa/",
   region,
  "/rf.geojson"
)

sl = sf::read_sf(u)
system.time({rnet1 = overline2(sl, "bicycle")})
system.time({rnet2 = overline2(sl, "bicycle", ncores = 4)})
identical(rnet1, rnet2)
lwd = rnet1$bicycle / mean(rnet1$bicycle)
plot(rnet1, lwd = lwd)
}
}
\seealso{
Other rnet: \code{\link{SpatialLinesNetwork}},
  \code{\link{calc_catchment_sum}},
  \code{\link{calc_catchment}},
  \code{\link{calc_moving_catchment}},
  \code{\link{calc_network_catchment}},
  \code{\link{find_network_nodes}}, \code{\link{gsection}},
  \code{\link{islines}}, \code{\link{lineLabels}},
  \code{\link{overline}},
  \code{\link{plot,SpatialLinesNetwork,ANY-method}},
  \code{\link{plot,sfNetwork,ANY-method}},
  \code{\link{sln2points}},
  \code{\link{sum_network_links}},
  \code{\link{sum_network_routes}}
}
\concept{rnet}
