% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-stats19.R
\name{read_stats19_ac}
\alias{read_stats19_ac}
\title{Import and format UK 'Stats19' road traffic casualty data}
\usage{
read_stats19_ac(data_dir = tempdir(), filename = "Accidents0514.csv")
}
\arguments{
\item{data_dir}{Character string representing where the data is stored.
If empty, R will attempt to download and unzip the data for you.}

\item{filename}{Character string of the filename of the .csv to read in - default values
are those downloaded from the UK Department for Transport (DfT).}
}
\description{
Import and format UK 'Stats19' road traffic casualty data
}
\section{Details}{

This is a wrapper function to access and load stats 19 data in a user-friendly way.
The function returns a data frame, in which each record is a reported incident in the
stats19 dataset.

Ensure you have a fast internet connection and at least 100 Mb space.
}

\examples{
\dontrun{
ac <- read_stats19_ac()
}
}
