% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadABS.R
\name{read_table_builder}
\alias{read_table_builder}
\title{Import and format Australian Bureau of Statistics (ABS) TableBuilder files}
\usage{
read_table_builder(dataset, filetype = "csv", sheet = 1, removeTotal = TRUE)
}
\arguments{
\item{dataset}{Either a dataframe containing the original data from
TableBuilder or a character string containing the path of the
unzipped TableBuilder file.}

\item{filetype}{A character string containing the filetype. Valid values
are 'csv', 'legacycsv' and 'xlsx' (default = 'csv'). Required even when
dataset is a dataframe. Use 'legacycsv' for csv files derived from earlier
versions of TableBuilder for which csv outputs were csv versions of the
xlsx files. Current csv output from TableBuilder follow a more standard
csv format.}

\item{sheet}{An integer value containing the index of the sheet in the
xlsx file (default = 1).}

\item{removeTotal}{A boolean value. If TRUE removes the rows and columns
with totals (default = TRUE).}
}
\description{
Import and format Australian Bureau of Statistics (ABS) TableBuilder files
}
\section{Details}{

The Australian Bureau of Statistics (ABS) provides customised tables for
census and other datasets in a format that is difficult to use in R
because it contains rows with additional information.
This function imports the original (unzipped) TableBuilder files in .csv
or .xlsx format before creating an R dataframe with the data.
}

\examples{
data_dir <- system.file("extdata", package = "stplanr")
t1 <- read_table_builder(file.path(data_dir, "SA1Population.csv"))
t2 <- read_table_builder(file.path(data_dir, "SA1Population.xlsx"),
  filetype = "xlsx", sheet = 1, removeTotal = TRUE
)
sa1pop <- read.csv(file.path(data_dir, "SA1Population.csv"), header = FALSE)
t3 <- read_table_builder(sa1pop)
}
\concept{data}
