% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catchmentArea.R
\name{calc_moving_catchment}
\alias{calc_moving_catchment}
\title{Calculate summary statistics for all features independently.}
\usage{
calc_moving_catchment(
  polygonlayer,
  targetlayer,
  calccols,
  distance = 500,
  projection = "worldalbers",
  retainAreaProportion = FALSE
)
}
\arguments{
\item{polygonlayer}{A SpatialPolygonsDataFrame containing zones from which
the summary statistics for the catchment variable will be calculated.
Smaller polygons will increase the accuracy of the results.}

\item{targetlayer}{A SpatialPolygonsDataFrame, SpatialLinesDataFrame or
SpatialPointsDataFrame object containing the specifications of the
facilities and zones for which the catchment areas are being calculated.}

\item{calccols}{A vector of column names containing the variables in the
polygonlayer to be used in the calculation of the summary statistics for
the catchment areas.}

\item{distance}{Defines the size of the catchment areas as the distance
around the targetlayer in the units of the projection
(default = 500 metres)}

\item{projection}{The proj4string used to define the projection to be used
for calculating the catchment areas or a character string 'austalbers' to
use the Australian Albers Equal Area projection. Ignored if the polygonlayer
is projected in which case the targetlayer will be converted to the
projection used by the polygonlayer. In all cases the resulting object will
be reprojected to the original coordinate system and projection of the
polygon layer. Default is an Albers Equal Area projection but for more
reliable results should use a local projection (e.g., Australian Albers
Equal Area project).}

\item{retainAreaProportion}{Boolean value. If TRUE retains a variable in
the resulting SpatialPolygonsDataFrame containing the proportion of the
original area within the catchment area (Default = FALSE).}
}
\description{
Calculate summary statistics for all features independently.
}
\section{Details}{

Calculates the summary statistics for a catchment area of multiple
facilities or zones using straight-line distance from variables
available in a SpatialPolygonsDataFrame with census tracts or other
zones. Assumes that the frequency of the variable is evenly distributed
throughout the zone. Returns the original source dataframe with additional
columns with summary variables.
}

\examples{
\dontrun{
data_dir <- system.file("extdata", package = "stplanr")
unzip(file.path(data_dir, "smallsa1.zip"))
unzip(file.path(data_dir, "testcycleway.zip"))
sa1income <- readOGR(".", "smallsa1")
testcycleway <- readOGR(".", "testcycleway")
calc_moving_catchment(
  polygonlayer = sa1income,
  targetlayer = testcycleway,
  calccols = c("Total"),
  distance = 800,
  projection = "austalbers"
)
}
}
\seealso{
Other rnet: 
\code{\link{SpatialLinesNetwork}},
\code{\link{calc_catchment_sum}()},
\code{\link{calc_catchment}()},
\code{\link{calc_network_catchment}()},
\code{\link{find_network_nodes}()},
\code{\link{gsection}()},
\code{\link{islines}()},
\code{\link{lineLabels}()},
\code{\link{overline_spatial}()},
\code{\link{overline}()},
\code{\link{plot,SpatialLinesNetwork,ANY-method}},
\code{\link{plot,sfNetwork,ANY-method}},
\code{\link{rnet_breakup_vertices}()},
\code{\link{rnet_group}()},
\code{\link{sln2points}()},
\code{\link{sum_network_links}()},
\code{\link{sum_network_routes}()}
}
\concept{rnet}
