% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{is_linepoint}
\alias{is_linepoint}
\title{Identify lines that are points}
\usage{
is_linepoint(l)
}
\arguments{
\item{l}{A spatial lines object}
}
\description{
OD matrices often contain 'intrazonal' flows, where the origin is the same point as the
destination. This function can help identify such intrazonal OD pairs, using 2 criteria:
the total number of vertices (2 or fewer) and whether the origin and destination are the same.
}
\details{
Returns a boolean vector. TRUE means that the associated line is in fact a point
(has no distance). This can be useful for removing data that will not be plotted.
}
\examples{
data(flowlines)
islp <- is_linepoint(flowlines)
nrow(flowlines)
sum(islp)
# Remove invisible 'linepoints'
nrow(flowlines[!islp, ])
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_sample}()},
\code{\link{line_segment_sf}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_sample_length}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()},
\code{\link{toptailgs}()},
\code{\link{update_line_geometry}()}
}
\concept{lines}
