% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrants.R
\name{quadrant}
\alias{quadrant}
\title{Split a spatial object into quadrants}
\usage{
quadrant(x, cent = NULL, number_out = FALSE)
}
\arguments{
\item{x}{Object of class sf}

\item{cent}{The centrepoint of the region of interest.
Quadrants will be defined based on this point.
By default this will be the geographic centroid of the zones.}

\item{number_out}{Should the result be returned as a number?}
}
\description{
Returns a character vector of NE, SE, SW, NW corresponding to north-east, south-east
quadrants respectively. If number_out is TRUE, returns numbers from 1:4, respectively.
}
\examples{
x = zones_sf
(quads <- quadrant(x))
plot(x$geometry, col = factor(quads))
}
\seealso{
Other geo: 
\code{\link{bbox_scale}()},
\code{\link{geo_bb_matrix}()},
\code{\link{geo_bb}()},
\code{\link{geo_buffer}()},
\code{\link{geo_length}()},
\code{\link{geo_projected}()},
\code{\link{geo_select_aeq}()}
}
\concept{geo}
