% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_coords}
\alias{od_coords}
\title{Create matrices representing origin-destination coordinates}
\usage{
od_coords(from = NULL, to = NULL, l = NULL)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}
}
\description{
This function takes a wide range of input data types (spatial lines, points or text strings)
and returns a matrix of coordinates representing origin (fx, fy) and destination (tx, ty) points.
}
\examples{
od_coords(from = c(0, 52), to = c(1, 53)) # lon/lat coordinates
od_coords(cents_sf[1:3, ], cents_sf[2:4, ]) # sf points
# od_coords("Hereford", "Leeds") # geocode locations
od_coords(flowlines_sf[1:3, ])
}
\seealso{
Other od: 
\code{\link{od2line}()},
\code{\link{od2odf}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords2line}()},
\code{\link{od_id_order}()},
\code{\link{od_id}},
\code{\link{od_oneway}()},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
