% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overline.R
\name{overline_intersection}
\alias{overline_intersection}
\title{Convert series of overlapping lines into a route network}
\usage{
overline_intersection(sl, attrib, fun = sum)
}
\arguments{
\item{sl}{An \code{sf} \code{LINESTRING} object with overlapping elements}

\item{attrib}{character, column names in sl to be aggregated}

\item{fun}{Named list of functions to summaries the attributes by? \code{sum} is the default.
\code{list(sum = sum, average = mean)} will summarise all \code{attrib}utes by sum and mean.}
}
\description{
This function takes overlapping \code{LINESTRING}s stored in an
\code{sf} object and returns a route network composed of non-overlapping
geometries and aggregated values.
}
\examples{
routes_fast_sf$value <- 1
sl <- routes_fast_sf[4:6, ]
attrib <- c("value", "length")
rnet <- overline_intersection(sl = sl, attrib)
plot(rnet, lwd = rnet$value)
# A larger example
sl <- routes_fast_sf[4:7, ]
rnet <- overline_intersection(sl = sl, attrib = c("value", "length"))
plot(rnet, lwd = rnet$value)
rnet_sf <- overline(routes_fast_sf[4:7, ], attrib = c("value", "length"))
plot(rnet_sf, lwd = rnet_sf$value)

# An even larger example (not shown, takes time to run)
# rnet = overline_intersection(routes_fast_sf, attrib = c("value", "length"))
# rnet_sf <- overline(routes_fast_sf, attrib = c("value", "length"), buff_dist = 10)
# plot(rnet$geometry, lwd = rnet$value * 2, col = "grey")
# plot(rnet_sf$geometry,  lwd = rnet_sf$value, add = TRUE)
}
