% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_pobs.R
\name{spm_pobs}
\alias{spm_pobs}
\title{Continuous-time multi-dimensional optimization for SPM with partially observed covariates (multidimensional GenSPM)}
\usage{
spm_pobs(x = NULL, y = NULL, aH = -0.05, aL = -0.01, f1H = 60,
  f1L = 80, QH = 2e-08, QL = 2.5e-08, fH = 60, fL = 80, bH = 4,
  bL = 5, mu0H = 8e-06, mu0L = 1e-05, thetaH = 0.08, thetaL = 0.1,
  p = 0.25, stopifbound = FALSE, algorithm = "NLOPT_LN_NELDERMEAD",
  lb = NULL, ub = NULL, maxeval = 500, verbose = FALSE,
  pinv.tol = 0.01, mode = "observed", gomp = TRUE, ftol_rel = 1e-06)
}
\arguments{
\item{x}{A data table with genetic component.}

\item{y}{A data table without genetic component.}

\item{aH}{A k by k matrix. Characterizes the rate of the adaptive response for Z = 1.}

\item{aL}{A k by k matrix. Characterize the rate of the adaptive response for Z = 0.}

\item{f1H}{A deviation from the norm (or optimal) state for Z = 1.
This is a vector of length k.}

\item{f1L}{A deviation from the norm (or optimal) for Z = 0. 
This is a vector of length k.}

\item{QH}{A matrix k by k, which is a non-negative-definite symmetric matrix for Z = 1.}

\item{QL}{A matrix k by k, which is a non-negative-definite symmetric matrix for Z = 0.}

\item{fH}{A vector with length of k. Represents the normal (or optimal) state for Z = 1.}

\item{fL}{A vector with length of k. Represents the normal (or optimal) state for Z = 0.}

\item{bH}{A diffusion coefficient, k by k matrix for Z = 1.}

\item{bL}{A diffusion coefficient, k by k matrix for Z = 0.}

\item{mu0H}{A baseline mortality for Z = 1.}

\item{mu0L}{A baseline mortality for Z = 0.}

\item{thetaH}{A displacement coefficient for Z = 1.}

\item{thetaL}{A displacement coefficient for Z = 0.}

\item{p}{a hyphotetical percentage of presence of partially observed covariate in a population (default p=0.25).}

\item{stopifbound}{If TRUE then estimation stops if at least one parameter achieves lower or upper boundaries.}

\item{algorithm}{An optimization algorithm used, can be one of those provided by \code{nloptr}. 
#'Check the NLopt website for a description of
the algorithms. Default: NLOPT_LN_NELDERMEAD}

\item{lb}{Lower bound of parameter values.}

\item{ub}{Upper bound of parameter values.}

\item{maxeval}{Maximum number of iterations of the algorithm for \code{nloptr} optimization. 
The program stops when the number of function evaluations exceeds maxeval. Default: 500.}

\item{verbose}{An indicator of verbosing output (FALSE by default).}

\item{pinv.tol}{A tolerance value for pseudo-inverse of matrix gamma (see Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.)}

\item{mode}{Can be one of the following: "observed" (default), "unobserved" or "combined". 
mode = "observed" represents analysing only dataset with observed variable Z.
mode = "unobserved" represents analysing only dataset of unobserved variable Z.
mode = "combined" denoted joint analysis of both observed and unobserved datasets.}

\item{gomp}{A flag (FALSE by default). When it is set, then time-dependent exponential form of mu0 is used:
mu0 = mu0*exp(theta*t).}

\item{ftol_rel}{Relative tolerance threshold for likelihood function (defalult: 1e-6), see http://ab-initio.mit.edu/wiki/index.php/NLopt_Reference}
}
\value{
A set of estimated parameters aH, aL, f1H, f1H, QH, QL, fH, fL, bH, bL, mu0H, mu0L, thetaH, thetaL, p and
additional variable \code{limit} which indicates if any parameter 
achieved lower or upper boundary conditions (FALSE by default).
}
\description{
Continuous-time multi-dimensional optimization for SPM with partially observed covariates (multidimensional GenSPM)
}
\examples{
library(stpm)
#Reading the data:
data <- sim_pobs(N=5)
head(data)
#Parameters estimation:
pars <- spm_pobs(x=data)
pars

}
\references{
Arbeev, K.G. et al (2009). Genetic model for longitudinal studies of aging, health, and longevity

Yashin, A.I. et al (2007). Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.<DOI:10.1016/j.mbs.2006.11.006>.
}

