% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_con_1d.r
\name{spm_con_1d}
\alias{spm_con_1d}
\title{Fitting a 1-D SPM model with constant parameters}
\usage{
spm_con_1d(spm_data, a = NA, b = NA, q = NA, f = NA, f1 = NA,
  mu0 = NA, theta = NA, lower = c(), upper = c(),
  control = list(xtol_rel = 1e-06), global = FALSE, verbose = TRUE,
  ahessian = FALSE)
}
\arguments{
\item{spm_data}{A dataset for the SPM model. See the STPM package for more details about the format.}

\item{a}{The initial value for the paramter \eqn{a}. The initial value will be predicted if not specified.}

\item{b}{The initial value for the paramter \eqn{b}. The initial value will be predicted if not specified.}

\item{q}{The initial value for the paramter \eqn{q}. The initial value will be predicted if not specified.}

\item{f}{The initial value for the paramter \eqn{f}. The initial value will be predicted if not specified.}

\item{f1}{The initial value for the paramter \eqn{f_1}. The initial value will be predicted if not specified.}

\item{mu0}{The initial value for the paramter \eqn{\mu_0} in the baseline hazard. The initial value will be predicted if not specified.}

\item{theta}{The initial value for the paramter \eqn{\theta} in the baseline hazard. The initial value will be predicted if not specified.}

\item{lower}{A vector of the lower bound of the parameters.}

\item{upper}{A vector of the upper bound of the parameters.}

\item{control}{A list of the control parameters for the optimization paramters.}

\item{global}{A logical variable indicating whether the MLSL (TRUE) or the L-BFGS (FALSE) algorithm is used for the optimization.}

\item{verbose}{A logical variable indicating whether initial information is printed.}

\item{ahessian}{A logical variable indicating whether the approximate (FALSE) or analytical (TRUE) Hessian is returned.}
}
\value{
est The estimates of the parameters.

hessian The Hessian matrix of the estimates.

lik The minus log-likelihood.

con A number indicating the convergence. See the 'nloptr' package for more details.

message Extra message about the convergence. See the 'nloptr' package for more details.
}
\description{
This function implements a analytical solution to estimate the parameters in the continuous SPM model by assuming all the parameters are constants.
}
\examples{
{ 
library(stpm) 
dat <- simdata_cont(N=500)
colnames(dat) <- c("id", "xi", "t1", "t2", "y", "y.next")
res <- spm_con_1d(as.data.frame(dat), a=-0.05, b=2, q=1e-8, f=80, f1=90, mu0=1e-3, theta=0.08)
}
}
\references{
He, L., Zhbannikov, I., Arbeev, K. G., Yashin, A. I., and Kulminski, A.M., 2017. Genetic stochastic process model for detecting pleiotropic and interaction effects with longitudinal data.
}
