% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{lv2m}
\alias{lv2m}
\title{List of (atomic) Vectors to Matrix}
\usage{
lv2m(lv, along, fill = FALSE, check = TRUE)
}
\arguments{
\item{lv}{list of (atomic) vectors.}

\item{along}{numeric vector of length 1 specifying either 1 for binding along rows
(i.e., each list element is a row) and 2 for binding along columns (i.e., each
list element in a column).}

\item{fill}{logical vector of length 1 specifying whether 1) to allow the vectors
in \code{lv} to have different lengths, names, or both, 2) to bind by the names
of the vectors within \code{lv} rather than by their positions (unless no names
are present in which case positions are used), and 3) fill in any missing values
in the return object with NA.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{lv} is a list of atomic
vectors. This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
matrix with the elements of \code{lv} either as rows or columns and dimnames
determined by the names of \code{lv} and \code{lv[[1]]}. The typeof is determined
by the highest typeof in the elements of \code{lv} (i.e., highest to lowest: character >
double > integer > logical).
}
\description{
\code{lv2m} converts a list of (atomic) vectors to a matrix. This function
is similar to a hypothetical \code{as.matrix.list} method if it existed.
Note, if the vectors are not all the same typeof, then the matrix will have
the most complex typeof any vector in \code{lv}.
}
\details{
If fill = FALSE, \code{lv2m} uses a combination of \code{do.call} and \code{rbind}
if \code{along} = 1 or \code{do.call} and \code{cbind} if \code{along} = 2.
rownames and colnames of the returned data.frame are determined by the names of
\code{lv} and the names of the first vector within \code{lv}. If either are NULL,
then the positions are used as the dimension names. If fill = FALSE, then an
error is returned ff the vectors in \code{lv} do not all have the same length.
If fill = FALSE, there is no check to ensure the elements within each \code{lv}
vector have the same names in the same order. The names are taken from the first
vector in \code{lv}, and it is assumed those names and their order apply to each
vector in \code{lv}. Essentially, if fill = FALSE, \code{lv} binds the vectors
by positions and not names.

If fill = TRUE, \code{lv2m} uses \code{plyr::rbind.fill.matrix} if \code{along} = 1 or
\code{plyr::rbind.fill.matrix} and \code{t.default} if \code{along} = 2. If fill = TRUE,
\code{lv2d} binds the vectors by by names (and by positions if no names are present).
Depending on what the user wants, fill = FALSE or TRUE could be safer. If the user
wants an error returned when any vectors within \code{lv} have different lengths,
then fill = FALSE should be used. If the user wants to bind by names rather than
position, then fill = TRUE should be used.
}
\examples{

# 1) `lv` has names; vectors have names
lv <- setNames(object = lapply(X = letters, FUN = setNames, nm = "alphabet"), nm = LETTERS)
lv2m(lv, along = 1)
lv2m(lv, along = 2)

# 2) `lv` has names; no vector names
lv <- setNames(object = as.list(letters), nm = LETTERS)
lv2m(lv, along = 1)
lv2m(lv, along = 2)

# 3) no `lv` names; vector have names
lv <- lapply(X = letters, FUN = setNames, nm = "alphabet")
lv2m(lv, along = 1)
lv2m(lv, along = 2)

# 4) no `lv` names; no vector names
lv <- as.list.default(letters)
lv2m(lv, along = 1)
lv2m(lv, along = 2)

# actual use case (sort of)
lv <- lapply(X = asplit(x = as.matrix(attitude), MARGIN = 1),
   FUN = undim) # need undim since asplit returns 1D arrays
cbind(lv) # not what we want
do.call(what = cbind, args = lv) # doesn't have useful dimnames
lv2m(lv, along = 2) # finally what we want

# when vectors have named elements in different positions
lv <- list("row_1" = c("col_A" = "col_A1", "col_B" = "col_B1", "col_C" = "col_C1"),
   "row_2" = c("col_B" = "col_B2", "col_C" = "col_C2", "col_A" = "col_A2"),
   "row_3" = c("col_C" = "col_C3", "col_A" = "col_A3", "col_B" = "col_B3"))
lv2m(lv, along = 1, fill = FALSE) # probably not what you want
lv2m(lv, along = 1, fill = TRUE) # what you want (See details)

# when you have a list with only one vector
lv <- list("A" = c("one" = 1, "two" = 2, "three" = 3))
x <- lv2m(lv, along = 1, fill = FALSE)
y <- lv2m(lv, along = 1, fill = TRUE)
identical(x, y)

}
