% Generated by roxygen2 (4.0.2): do not edit by hand
\name{allele.freqs}
\alias{allele.freqs}
\title{Allele Frequencies}
\usage{
allele.freqs(g, use.na.rows = FALSE)
}
\arguments{
\item{g}{a \code{gtypes} object.}

\item{use.na.rows}{logical. FALSE deletes any row with an NA for either allele.
  TRUE uses all unique (non-NA) alleles in frequency.}
}
\value{
A list of allele or haplotype frequencies.
}
\description{
Allele Frequencies
}
\examples{
data(dolph.strata)
data(dolph.msats)

msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5)

allele.freqs(msats)[c(1, 5)]
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

