% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alleleFreqFormat.R
\name{alleleFreqFormat}
\alias{alleleFreqFormat}
\title{Compiles and Formats Allele Frequencies}
\usage{
alleleFreqFormat(x, g)
}
\arguments{
\item{x}{a matrix or data.frame where first column is sample id and 
second colum is locus name.}

\item{g}{a \linkS4class{gtypes} object.}
}
\value{
matrix of original samples, loci, and a formatted character 
  string giving alleles and their overall frequencies in the data.
}
\description{
Format allele frequencies to for a set of ids and loci
}
\examples{
data(msats.g)

x <- cbind(
 id = sample(indNames(msats.g), 10, rep = TRUE),
 locus = sample(locNames(msats.g), 10, rep = TRUE)
)
alleleFreqFormat(x, msats.g)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\link{alleleFreqs}
}

