% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtypes.class.R
\docType{class}
\name{gtypes-class}
\alias{gtypes}
\alias{gtypes-class}
\title{\code{gtypes} Class}
\description{
An S4 class storing multi-allelic locus or sequence data along
  with a current stratification and option stratification schemes.
}
\section{Slots}{

\describe{
\item{\code{loci}}{a data.frame containing the allelic data as one column per locus.
Alleles are on multiple rows per column with samples listed in the same
order for each allele. rownames are sample names plus allele number
formatted as 12345.1 and 12345.2 where 12345 is the sample name and 1 and
2 are the first and second alleles. colnames are unique locus names.}

\item{\code{sequences}}{a \linkS4class{multidna} object.}

\item{\code{ploidy}}{integer representing the ploidy of the data. There are
ploidy * the number of samples rows in 'loci'.}

\item{\code{strata}}{a factor or vector that can be coerced as to a factor as long 
as the number of samples representing the current stratification scheme.}

\item{\code{schemes}}{a data.frame with stratification schemes in each column.
Sample names are in the rownames and must match the first part of the
sample names (rownames) of the 'loci' slot. Each column is a factor.}

\item{\code{description}}{a label for the object (optional).}

\item{\code{other}}{a slot to carry other related information - unused in package
analyses (optional).}
}}
\examples{

#--- create a diploid (microsatellite) gtypes object
data(dolph.msats)
data(dolph.strata)
strata.schemes <- dolph.strata[, c("broad", "fine")]
rownames(strata.schemes) <- dolph.strata$id
msats.g <- new("gtypes", gen.data = dolph.msats[, -1], ploidy = 2,
               ind.names = dolph.msats[, 1], schemes = strata.schemes)
msats.g

#--- create a haploid sequence (mtDNA) gtypes object and label haplotypes
data(dolph.seqs)
dloop.haps <- cbind(dLoop = dolph.strata$id)
rownames(dloop.haps) <- dolph.strata$id
dloop.g <- new("gtypes", gen.data = dloop.haps, ploidy = 1, 
               schemes = strata.schemes, sequences = dolph.seqs, 
               strata = "fine")
dloop.g
dloop.g <- labelHaplotypes(dloop.g, "Hap.")$gtypes
dloop.g

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{df2gtypes}}, \code{\link{sequence2gtypes}},
  \code{\link{genind2gtypes}}, \code{\link{gtypes.accessors}},
  \code{\link{initialize.gtypes}}
}

